package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageConditionDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageSaveDTO;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.vo.crowd.*;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/16 12:03
 */
public interface CrowdPackageService extends IService<CrowdPackage> {
    /**
     * 插入人群包
     *
     * @param saveDTO 人群包保存DTO
     * @return {@link BaseResult}
     */
    GenericsResult<CrowdPackageCommonIdVO> insertCrowdPackage(CrowdPackageSaveDTO saveDTO);


    /**
     * 新增人群包条件
     *
     * @param conditionDto 条件dto
     * @return {@link BaseResult}
     */
    GenericsResult<CrowdPackageCommonIdVO> insertConditionIntoPackage(CrowdPackageConditionDTO conditionDto);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageListVO}>>
     */
    GenericsResult<PageInfo<CrowdPackageListVO>> pageList(CrowdPackageQueryDTO queryDto);
    GenericsResult<List<CrowdPackageListVO>> getAllPackage(CrowdPackageQueryDTO queryDto);

    /**
     * 删除群包
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult removeCrowdPackage(Long id);


    /**
     * 删除条件
     *
     * @param linkedId 人群包-条件 关联主键
     * @return {@link BaseResult}
     */
    BaseResult removeConditionFromPackage(Long linkedId);


    /**
     * 得到包条件列表
     *
     * @param id id
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageConditionVO}>>
     */
    GenericsResult<CrowdPackageDetailVO> getPackageInfo(Long id);


    /**
     * 得到所有条件
     *
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageConditionVO}>>
     */
    GenericsResult<List<CrowdPackageConditionVO>> getAllConditions();


    /**
     * 得到某个条件的可选项
     *
     * @param conditionId 状态标识
     * @return {@link GenericsResult}<{@link ConditionOptionResponseVO}
     */
    GenericsResult<ConditionOptionResponseVO> getOptions(Long conditionId);

    /**
     * 更新用户所属人群包
     * @param openId 用户标识
     * @return 人群包id拼接
     */
    BaseResult updateUserPackageBelong(String openId);


    /**
     * 批处理更新用户包
     *
     * @param openIdList 开放id列表
     * @return {@link BaseResult}
     */
    BaseResult updateUserPackageBatch(List<String> openIdList);

    /**
     * 更新包num人群复述
     */
    void updateCrowdPackageNumFromRedis();

    /**
     * 根据人群包名称列表完全匹配查询
     *
     * @param packageNames 人群包名称列表
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageListVO}>>
     */
    GenericsResult<List<CrowdPackageListVO>> getByPackageNames(List<String> packageNames);

}
