package com.yaoyaozw.customer.service;

import com.yaoyaozw.customer.dto.AcquisitionExceptionHandleParam;

import java.util.List;

public interface CompanyAcquisitionLinkService {

    /**
     * 校验链接是否是源公众号的获客链接，如果是的，查找目标公众号的链接，并返回（如果不是获客链接，则会返回原链接，如果是，但找不到目标公众号的获客链接，则返回空）
     * @param sourceReferral 原链接
     * @param targetAuthId 目标公众号
     * @return 链接
     */
    String checkAndSearchTargetReferral(String sourceReferral, Long targetAuthId);

    /**
     * 根据链接Id获取绑定同公众号的其它获客链接列表
     * @param linkId 链接Id
     * @return 信息
     */
    AcquisitionExceptionHandleParam getReplaceAcquisitionEntityByLinkId(String linkId);

    /**
     * 获取指定公众号的获客链接列表
     * @param appId 公众号appId
     * @param type 获客链接类型，如"OPERATE"
     * @return 获客链接列表
     */
    List<String> getAcquisitionLinksByAppId(String appId, String type);

}
