package com.yaoyaozw.customer.entity;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageSaveDTO;

/**
 * 人群中包
 *
 * @author darker
 * @date 2022/09/16
 */
@Data
@TableName("crowd_package_main")
@NoArgsConstructor
public class CrowdPackage implements Serializable {
    /**
     * 主键ID
     */
    @Id
    @TableId("id")
    private Long id;

    /**
     * 人群包名称
     */
    @TableField("package_name")
    private String packageName;

    /**
     * 活跃时间左边界
     */
    @TableField("active_time_min")
    private Long activeTimeMin;

    /**
     * 活跃时间右边界
     */
    @TableField("active_time_max")
    private Long activeTimeMax;

    /**
     * 关注时间左边界
     */
    @TableField("follow_time_min")
    private Integer followTimeMin;

    /**
     * 关注时间右边界
     */
    @TableField("follow_time_max")
    private Integer followTimeMax;

    /**
     * 关注开始日期
     */
    @TableField("follow_date_start")
    private Date followDateStart;

    /**
     * 关注结束日期
     */
    @TableField("follow_date_end")
    private Date followDateEnd;

    /**
     * 人群包用户人数
     */
    @TableField("crowd_num")
    private Integer crowdNum;

    /**
     * 人数最后统计时间
     */
    @TableField("last_count_time")
    private Date lastCountTime;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @TableField("create_user")
    private Long createUser;

    /**
     * 修改时间
     */
    @TableField("modified_time")
    private Date modifiedTime;

    /**
     * 修改人
     */
    @TableField("modified_user")
    private Long modifiedUser;

    private static final long serialVersionUID = 1L;

    public CrowdPackage(Long id, String packageName, Double activeTimeMin, Double activeTimeMax, Integer followTimeMin, Integer followTimeMax, String followDateStart, String followDateEnd) {
        this.id = id;
        this.packageName = packageName;
        this.followTimeMin = followTimeMin == null || followTimeMin == 0 ? null : followTimeMin;
        this.followTimeMax = followTimeMax == null || followTimeMax == 0 ? null : followTimeMax;
        this.followDateStart = parseStringToDate(followDateStart);
        this.followDateEnd = parseStringToDate(followDateEnd);

        if (ObjectUtil.isNotNull(activeTimeMin)) {
            Double v = activeTimeMin * CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
            this.activeTimeMin = v.longValue();
        }
        if (ObjectUtil.isNotNull(activeTimeMax)) {
            Double v = (activeTimeMax * CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE);
            this.activeTimeMax = v.longValue();
        }
    }

    public CrowdPackage(CrowdPackageSaveDTO saveDTO) {
        this.id = saveDTO.getId();
        this.packageName = saveDTO.getName();
        this.followTimeMin = saveDTO.getFollowTimeMin() == null || saveDTO.getFollowTimeMin() == 0 ? null : saveDTO.getFollowTimeMin();
        this.followTimeMax = saveDTO.getFollowTimeMax() == null || saveDTO.getFollowTimeMax() == 0 ? null : saveDTO.getFollowTimeMax();
        this.followDateStart = parseStringToDate(saveDTO.getFollowDateStart());
        this.followDateEnd = parseStringToDate(saveDTO.getFollowDateEnd());

        if (ObjectUtil.isNotNull(saveDTO.getActiveTimeMin())) {
            Double v = saveDTO.getActiveTimeMin() * CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
            this.activeTimeMin = v.longValue();
        }
        if (ObjectUtil.isNotNull(saveDTO.getActiveTimeMax())) {
            Double v = (saveDTO.getActiveTimeMax() * CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE);
            this.activeTimeMax = v.longValue();
        }
    }

    /**
     * 将字符串日期转换为Date对象
     * @param dateStr 日期字符串，格式：yyyy-MM-dd
     * @return Date对象，如果输入为空或转换失败返回null
     */
    private Date parseStringToDate(String dateStr) {
        if (StrUtil.isBlank(dateStr)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(dateStr);
        } catch (ParseException e) {
            // 日期格式错误，返回null
            return null;
        }
    }

    public void handleInfo(Date now, Long userId, Boolean isCreate) {
        if (isCreate) {
            this.createTime = now;
            this.createUser = userId;
        }
        this.modifiedTime = now;
        this.modifiedUser = userId;
    }
}

