package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 授权方扩展信息表
 *
 * @author system
 * @since 2025-01-01
 */
@ApiModel(value = "authorizer_expand_info")
@Data
@TableName(value = "authorizer_expand_info")
public class AuthorizerExpandInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty(value = "主键ID")
    private Long id;

    @TableField(value = "authorizer_id")
    @ApiModelProperty(value = "authorizer_info 主键Id")
    private Long authorizerId;

    @TableField(value = "authorizer_appid")
    @ApiModelProperty(value = "公众号AppId")
    private String authorizerAppid;

    @TableField(value = "mp_appid")
    @ApiModelProperty(value = "关联小程序appId")
    private String mpAppid;

    @TableField(value = "mp_name")
    @ApiModelProperty(value = "关联小程序名称")
    private String mpName;

    @TableField(value = "mp_distributor_id")
    @ApiModelProperty(value = "小程序分销商Id")
    private String mpDistributorId;

    @TableField(value = "flag_id")
    @ApiModelProperty(value = "公众号在书城的标识Id")
    private String flagId;

    @TableField(value = "gmt_create")
    @ApiModelProperty(value = "创建时间")
    private Date gmtCreate;

    @TableField(value = "gmt_modified")
    @ApiModelProperty(value = "修改时间")
    private Date gmtModified;

    public static final String COL_ID = "id";
    public static final String COL_AUTHORIZER_ID = "authorizer_id";
    public static final String COL_AUTHORIZER_APPID = "authorizer_appid";
    public static final String COL_MP_APPID = "mp_appid";
    public static final String COL_MP_NAME = "mp_name";
    public static final String COL_MP_DISTRIBUTOR_ID = "mp_distributor_id";
    public static final String COL_FLAG_ID = "flag_id";
    public static final String COL_GMT_CREATE = "gmt_create";
    public static final String COL_GMT_MODIFIED = "gmt_modified";
}

