package com.yaoyaozw.customer.dto.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 批量设置人群包DTO
 * @author system
 * @date 2024/01/01
 */
@Data
public class CustomerBatchSetPackDTO implements Serializable {

    @ApiModelProperty("客服消息ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long customerMessageId;

    @ApiModelProperty("人群包ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long packId;

    @ApiModelProperty("人群包名称")
    private String packName;

    @ApiModelProperty("操作人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long operateUserId;

    private static final long serialVersionUID = 1L;
} 