package com.yaoyaozw.customer.consumer;

import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.constants.RabbitCommonNameConstant;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class CustomerConsumer {

    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @RabbitListener(queues = RabbitCommonNameConstant.YG_LIMIT_DEATH_QUEUE)
    public void listener() {
        redisTemplate.opsForValue().decrement(CustomerCommonConstant.YANG_GUANG_ACCESS_LIMIT_REDIS_KEY);
    }

}
