package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.components.FollowReplyComponent;
import com.yaoyaozw.customer.components.SnowflakeComponent;
import com.yaoyaozw.customer.constants.CustomerMaterialConstant;
import com.yaoyaozw.customer.dto.follow.FollowReplyMultiNewsCreateDTO;
import com.yaoyaozw.customer.dto.follow.NewsMessageReplyEntity;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.entity.CustomerFollowReply;
import com.yaoyaozw.customer.entity.CustomerFollowReplyMultiNews;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.mapper.CustomerFollowReplyMultiNewsMapper;
import com.yaoyaozw.customer.service.CustomerFollowReplyMultiNewsService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author darker
 * @date 2023/11/1 14:29
 */
@Service
public class CustomerFollowReplyMultiNewsServiceImpl extends ServiceImpl<CustomerFollowReplyMultiNewsMapper, CustomerFollowReplyMultiNews> implements CustomerFollowReplyMultiNewsService {
    private final static Logger localLog = LoggerFactory.getLogger(CustomerFollowReplyMultiNewsServiceImpl.class);


    @Autowired
    private ReferralEntityService referralEntityService;
    @Autowired
    private FollowReplyComponent followReplyComponent;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private SnowflakeComponent snowflakeComponent;

    @Override
    public void saveFollowReplyMultiNews(Long replyId, AuthInfoVO accountEntity, List<FollowReplyMultiNewsCreateDTO> multiNewsList) {
        if (CollectionUtil.isEmpty(multiNewsList)) {
            return;
        }
        localLog.info("reply id {} save multi news size {}", replyId, multiNewsList.size());
        // 删除这个replyId当前的所有的多图文配置
        List<CustomerFollowReplyMultiNews> currentMultiNewsList = this.list(new QueryWrapper<CustomerFollowReplyMultiNews>().eq("reply_id", replyId));
        if (CollectionUtil.isNotEmpty(currentMultiNewsList)) {
            // 删除这些多图文配置对应的referral_entity 数据
            List<Long> multiNewsIdList = currentMultiNewsList.stream().map(CustomerFollowReplyMultiNews::getId).collect(Collectors.toList());
            referralEntityService.remove(new QueryWrapper<ReferralEntity>().in(ReferralEntity.COL_MATERIAL_GRAPHICS_ID, multiNewsIdList));
            this.removeByIds(multiNewsIdList);
            redisTemplate.opsForHash().delete(CustomerMaterialConstant.FOLLOW_REPLY_MULTI_NEWS_CACHE_KEY, accountEntity.getAppId());
        }
        List<ReferralEntity> referralEntityList = new ArrayList<>(multiNewsList.size());
        List<CustomerFollowReplyMultiNews> entityList = new ArrayList<>(multiNewsList.size());
        // 处理链接
        for (FollowReplyMultiNewsCreateDTO multiNewsEntity : multiNewsList) {
            CommonReferralBody referralBody = multiNewsEntity.getReferralBody();
            referralBody.setAccountName(accountEntity.getAccountName());
            referralBody.setStoreTypeName(accountEntity.getStoreTypeName());
            referralBody.setStoreType(accountEntity.getStoreType());
            referralBody.setInfoId(accountEntity.getId());
            referralBody.setAccountId(accountEntity.getAccountId());
            referralBody.setAppId(accountEntity.getAppId());

            // 调用通用方法生成referralEntity
            ReferralEntity referralEntity = followReplyComponent.getCreateReferralEntity(referralBody);
            // 将生成的链接设置到多图文表中
            multiNewsEntity.setLinkUrl(referralEntity.getReferral());

            CustomerFollowReplyMultiNews entity = new CustomerFollowReplyMultiNews();
            BeanUtil.copyProperties(multiNewsEntity, entity);
            entity.setId(snowflakeComponent.snowflakeId());
            entity.setReplyId(replyId);
            referralEntity.setMaterialGraphicsId(entity.getId());
            entityList.add(entity);
            referralEntity.setId(snowflakeComponent.snowflakeId());
            referralEntityList.add(referralEntity);
        }
        localLog.info("generate multi news size {}, referral entity size {}", entityList.size(), referralEntityList.size());
        // 将这些多图文信息转换到缓存
        List<NewsMessageReplyEntity> cacheEntityList = JSONUtil.toList(JSONUtil.parseArray(multiNewsList), NewsMessageReplyEntity.class);
        redisTemplate.opsForHash().put(CustomerMaterialConstant.FOLLOW_REPLY_MULTI_NEWS_CACHE_KEY, accountEntity.getAppId(), JSONUtil.toJsonStr(cacheEntityList));
        this.saveBatch(entityList);
        referralEntityService.saveBatch(referralEntityList);
    }
}
