package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 订单表
 */
@Data
@TableName(value = "account_order")
public class AccountOrder implements Serializable {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 投放信息外键
     */
    @TableField(value = "setup_id")
    private Long setupId;

    /**
     * 分成后收入
     */
    @TableField(value = "profit")
    private Double profit;

    /**
     * 下单完成时间
     */
    @TableField(value = "finish_time")
    private Date finishTime;

    /**
     * 类型
     */
    @TableField(value = "`type`")
    private Integer type;

    /**
     * 用户OPENID
     */
    @TableField(value = "open_id")
    private String openId;

    /**
     * 用户关注时间
     */
    @TableField(value = "user_subscribe_time")
    private Date userSubscribeTime;

    private static final long serialVersionUID = 1L;

    public static final String COL_ID = "id";

    public static final String COL_SETUP_ID = "setup_id";

    public static final String COL_PROFIT = "profit";

    public static final String COL_FINISH_TIME = "finish_time";

    public static final String COL_TYPE = "type";

    public static final String COL_OPEN_ID = "open_id";

    public static final String COL_USER_SUBSCRIBE_TIME = "user_subscribe_time";
}