package com.yaoyaozw.customer.dto.keyword;

import com.yaoyaozw.customer.entity.CommonReferralBody;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author darker
 * @date 2023/3/13 19:59
 */
@Data
public class CustomerKeywordSaveDTO implements Serializable {

    private Long id;

    @NotEmpty(message = "appid不能为空")
    private String appid;

    @NotEmpty(message = "关键词不能为空")
    private String keyword;

    @NotEmpty(message = "素材类型不能为空")
    private String type;

    private String originMediaUrl;

    private String extendTitle;

    private String extendDesc;

    @NotNull(message = "素材排序不能为空")
    private Integer sort;

    private CommonReferralBody referralBody;
}
