package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordCopyDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordQueryDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordSaveDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.service.CustomerKeywordService;
import com.yaoyaozw.customer.vo.keyword.CustomerKeywordInfoVO;
import com.yaoyaozw.customer.vo.keyword.CustomerKeywordListVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author darker
 * @date 2023/3/20 11:14
 */
@RestController
@RequestMapping("/keyword")
public class CustomerKeywordController {

    @Autowired
    private CustomerKeywordService keywordService;

    @PostMapping("/list")
    public GenericsResult<List<CustomerKeywordListVO>> list(@RequestBody CustomerKeywordQueryDTO queryDto) {
        return keywordService.list(queryDto);
    }

    @PostMapping("/create")
    @OperateLog(module = "客服-关回", desc = "创建素材")
    public GenericsResult<String> create(@RequestBody @Validated CustomerKeywordSaveDTO saveDto) {
        return keywordService.create(saveDto);
    }

    @PostMapping("/createTextItem")
    @OperateLog(module = "客服-关回", desc = "创建文本子素材")
    public GenericsResult<List<CommonReferralBody>> createTextItem(@RequestBody CommonReferralBody referralBody) {
        return keywordService.createTextItem(referralBody);
    }

    @GetMapping("/info/{id}")
    public GenericsResult<CustomerKeywordInfoVO> getInfo(@PathVariable("id") Long id) {
        return keywordService.getInfo(id);
    }

    @GetMapping("/remove/{id}")
    @OperateLog(module = "客服-关回", desc = "删除素材")
    public BaseResult remove(@PathVariable("id") Long id) {
        return keywordService.remove(id);
    }

    @GetMapping("/removeTextItem/{id}")
    @OperateLog(module = "客服-关回", desc = "删除文本子素材")
    public GenericsResult<List<CommonReferralBody>> removeTextItem(@PathVariable("id") Long id) {
        return keywordService.removeTextItem(id);
    }

    @PostMapping("/copy")
    @OperateLog(module = "客服-关回", desc = "关回复用")
    public BaseResult copy(@RequestBody CustomerKeywordCopyDTO copyDto) {
        return keywordService.copy(copyDto);

    }

}
