package com.yaoyaozw.customer.dto.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 预览图文DTO
 * @author system
 * @date 2024/01/01
 */
@Data
@ApiModel("预览图文DTO")
public class CustomerGraphicsPreviewDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("客服消息ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("授权方ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long authId;

    @ApiModelProperty("用户OpenId")
    private String userOpenId;

}

