package com.yaoyaozw.customer.annotations;


import com.yaoyaozw.customer.enums.AccountParamType;
import com.yaoyaozw.customer.enums.AccountTableColumnType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author darker
 * @date 2022/12/13 12:04
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface AccountOperateControl {

    AccountParamType paramType();

    // 校验参数名
    String paramName();

    // 校验参数类型, 是appId 还是 公众号主键id
    AccountTableColumnType columnType() default AccountTableColumnType.AUTH_ID;


    // property是 paramType 为 REQUEST_BODY 时, 用于指定参数实体类中公众号校验字段的字段名
    String property() default "authId";

    // table 和 column 是当 paramType 为 TABLE_PRIMARY 时需要的参数 table指定主键对应的表名，column指定该表中的公众号字段名
    String table() default "";
    String column() default "auth_id";

}
