package com.yaoyaozw.customer.configs;

import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @author darker
 * @date 2022/10/21 16:04
 */
@Configuration
public class RabbitConfig {

    @Bean
    public Queue directQueue(){
        Map<String, Object> map = new HashMap<>(4);
        map.put("x-dead-letter-exchange", "DEATH_EXCHANGE");
        map.put("x-dead-letter-routing-key", "death");
        map.put("x-max-length", 30);
        map.put("x-message-ttl", 60000);
        map.put("x-overflow", 60000);
        return new Queue("YG_ACCESS_LIMIT", true, false, false, map);
    }

    @Bean
    public DirectExchange directExchange(){
        return new DirectExchange("TTL_EXCHANGE");
    }

    @Bean
    public Queue deathQueue(){
        return new Queue("DEATH_QUEUE");
    }

    @Bean
    public DirectExchange deathExchange(){
        return new DirectExchange("DEATH_EXCHANGE");
    }

    @Bean
    public Binding bindingDirect(){
        return BindingBuilder.bind(directQueue()).to(directExchange()).with("yg_limit");
    }

    @Bean
    public Binding bindingDeath(){
        return BindingBuilder.bind(deathQueue()).to(deathExchange()).with("death");
    }


}
