package com.yaoyaozw.customer.publisher;

import com.yaoyaozw.customer.dto.AcquisitionExceptionHandleParam;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.event.AcquisitionExceptionEvent;
import com.yaoyaozw.customer.service.CompanyAcquisitionLinkService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author eumenides
 * @time 2024/12/13 17:44
 */
@Slf4j
@Component
public class AcquisitionExceptionEventPublisher {

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    @Resource
    private CompanyAcquisitionLinkService companyAcquisitionLinkService;


    public void inspectAndExecute(String linkId) {
        if (StringUtils.isBlank(linkId)) {
            return;
        }
        try {
            // 查链接Id对应的链接数据
            AcquisitionExceptionHandleParam replaceAcquisitionEntity = companyAcquisitionLinkService.getReplaceAcquisitionEntityByLinkId(linkId);
            if (replaceAcquisitionEntity == null) {
                log.warn("链接异常处理异常，链接Id：{}，没有对应的可替换链接数据", linkId);
                return;
            }
            AuthorizerInfo authorizerInfo = replaceAcquisitionEntity.getAuthorizerInfo();
            String fromPath = replaceAcquisitionEntity.getFromPath();
            // 查询可用于替换的链接
            String toPath = replaceAcquisitionEntity.getToPath();

            this.publishAcquisitionExceptionEvent(new AcquisitionExceptionHandleParam(authorizerInfo, fromPath, toPath));
        } catch (Exception e) {
            log.error("链接异常处理异常，链接Id：{}", linkId, e);
        }
    }



    public void publishAcquisitionExceptionEvent(AcquisitionExceptionHandleParam source) {
        if (source == null || source.getAuthorizerInfo() == null || StringUtils.isAnyBlank(source.getFromPath(), source.getToPath())) {
            return;
        }
        log.info("准备替换公众号：{} 获客链接：{} 为：{}", source.getAuthorizerInfo().getNickName(), source.getFromPath(), source.getToPath());
        applicationEventPublisher.publishEvent(new AcquisitionExceptionEvent(source));
    }



}
