package com.yaoyaozw.customer.service.wechat.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.utils.JSONUtils;
import com.yaoyaozw.customer.service.wechat.entity.WeChatResponseEntity;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

@Service
public class WeChatRestService {

    /**
     * POST请求
     * @param fullPath 请求路径
     * @param queryMap query
     * @param requestMap Body
     * @param urlParams 路径变量
     * @param responseEntity 返回实体
     * @param <T> 泛型
     * @return 响应结果
     * @throws RestClientException 异常
     */
    public <T> ResponseEntity<T> postRequest(String fullPath, MultiValueMap<String, String> queryMap, Map<String, Object> requestMap, Map<String,Object> urlParams, Class<T> responseEntity)
            throws RestClientException {

        RestTemplate restTemplate = new RestTemplate();

        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(fullPath).queryParams(queryMap);

        UriComponents uriComponents=uriComponentsBuilder.build();

        if (urlParams!=null){

            uriComponents = uriComponentsBuilder.buildAndExpand(urlParams);
        }
        ResponseEntity<T> result = restTemplate.postForEntity(uriComponents.toUri(), requestMap, responseEntity);

        return result;

    }


    public <T> ResponseEntity<T> sendPostRequest(String fullPath, Class<T> responseEntity, Object requestEntity)
            throws URISyntaxException, RestClientException {
        RestTemplate restTemplate = new RestTemplate();
        URI uri = new URI(fullPath);
        ResponseEntity<T> result = restTemplate.postForEntity(uri, requestEntity, responseEntity);

        return result;

    }

    public <T>Object httpPostRequest(String fullPath, Object requestEntity,Class<T> responseEntity)throws Exception{

        HttpClient defaultHttpClient = HttpClients.createDefault();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(fullPath);
        HttpPost httpPost = new HttpPost(uriComponentsBuilder.toUriString());
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        if (requestEntity != null) {
            //转换为json格式并打印
            String json = JSONObject.toJSONString(requestEntity);
            HttpEntity httpEntity = new StringEntity(json, "utf-8");
            httpPost.setEntity(httpEntity);
        }
        HttpResponse httpResponse = defaultHttpClient.execute(httpPost);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            String errorLog = "请求失败，errorCode:" + httpResponse.getStatusLine().getStatusCode();
            throw new Exception(fullPath + errorLog);
        }
        //读取返回信息
        String output;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), "utf-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((output = bufferedReader.readLine()) != null) {
            stringBuilder.append(output);
        }
        String s = stringBuilder.toString();
        return JSONUtils.deserializeObject(s, responseEntity);

    }
}
