package com.yaoyaozw.customer.schedules;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.entity.CrowdPackageConditionMatch;
import com.yaoyaozw.customer.service.CrowdPackageConditionMatchService;
import com.yaoyaozw.customer.service.CrowdPackageService;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/23 10:18
 */
@Component
public class CrowdPackageSchedule {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CrowdPackageSchedule.class);

    @Autowired
    private CrowdPackageService crowdPackageService;
    @Autowired
    private CrowdPackageConditionMatchService matchService;

    /**
     * 计算人群包用户人数
     */
//    @Scheduled(cron = "0 0 10 * * ?")
    public void calCrowdPackageHumanNum() {
        LOCAL_LOG.info("获取人群包列表");
        CrowdPackageQueryDTO crowdPackageQuery = new CrowdPackageQueryDTO();
        List<CrowdPackageListVO> crowdPackageList = crowdPackageService.pageList(crowdPackageQuery).getData();
        // 没有人群包
        if (CollectionUtil.isEmpty(crowdPackageList)) {
            LOCAL_LOG.info("未找到符合条件的人群包");
            return;
        }
        LOCAL_LOG.info("共获得人群包 {} 条", crowdPackageList.size());

        // 遍历人群包，依次处理
        for (CrowdPackageListVO crowdPackageVo : crowdPackageList) {
            LOCAL_LOG.info("当前处理人群包: 【{}】", crowdPackageVo.getPackageName());
            // 获取人群包下的条件
            List<CrowdPackageConditionMatch> packageConditionList = matchService.list(new QueryWrapper<CrowdPackageConditionMatch>().eq("package_id", crowdPackageVo.getId()));
            LOCAL_LOG.info("共获取人群包下条件 {} 条", packageConditionList.size());


        }


    }

}
