package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口")
@RestController
@RequestMapping("/delay-customer-service")
public class CustomerDelayController {



    @ApiOperation("新增")
    @PostMapping("/insert")
    public BaseResult insertCrowdPackage(@RequestBody CustomerDelaySaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("编辑")
    @PostMapping("/edit")
    public BaseResult updateCrowdPackage(@RequestBody CustomerDelaySaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<CustomerDelayListVO>> pageList(@RequestBody CustomerDelayQueryDTO queryDto) {
        return new GenericsResult<>(new ArrayList<>());
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCrowdPackage(@PathVariable("id") Long id) {
        return new BaseResult().success();
    }


}
