package com.yaoyaozw.customer.scheduling;

import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.service.AccountOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;

@Component
public class SchedulingTask {

    @Autowired
    private AccountOrderService accountOrderService;


    /**
     * 拉取付费订单(每15min一次)
     */
    public void retrieveOrderData(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    /**
     * 更新付费用户近一月平均充值(每天一次）
     */
    public void retrieveMonthOrder(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        accountOrderService.calculateAvgMonth(integrationRequestDTO);

    }


    /**
     * 每段时间扫描一次正常客服
     */
    public void publishCustomerMessage(){


    }
}
