package com.yaoyaozw.customer.vo.crowd;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import com.yaoyaozw.customer.entity.CrowdPackage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/19 17:44
 */
@Data
@ApiModel("人群包详情页回显实体")
@NoArgsConstructor
public class CrowdPackageDetailVO implements Serializable {

    @ApiModelProperty("人群包主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long packageId;

    @ApiModelProperty("人群包名")
    private String packageName;

    @ApiModelProperty("活跃时间左边界")
    private Double activeTimeMin;

    @ApiModelProperty("活跃时间右边界")
    private Double activeTimeMax;

    @ApiModelProperty("已配置的人群包条件")
    private List<CrowdPackageConditionMatchVO> conditionList;

    public CrowdPackageDetailVO(CrowdPackage byId) {
        this.packageId = byId.getId();
        this.packageName = byId.getPackageName();
        if (ObjectUtil.isNotNull(byId.getActiveTimeMin())) {
            this.activeTimeMin = byId.getActiveTimeMin().doubleValue() / CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
        }
        if (ObjectUtil.isNotNull(byId.getActiveTimeMax())) {
            this.activeTimeMax = byId.getActiveTimeMax().doubleValue() / CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
        }
    }
}
