package com.yaoyaozw.customer.feigns;

import com.yaoyaozw.customer.common.R;
import com.yaoyaozw.customer.entity.ReferralEntity;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * 推荐装客户端
 *
 * @author Admin
 * @date 2022/10/09
 */
@FeignClient("referral-service-wgh")
public interface ReferralFeignClient {

    /**
     * 产品推荐
     *
     * @param referralEntity 推荐实体
     * @return {@link R}
     */
    @PostMapping("/getReferral")
    R productReferral(@RequestBody ReferralEntity referralEntity);


    /**
     * 获取活动config
     *
     * @param Key       关键
     * @param storeType 存储类型
     * @param infoId    信息标识
     * @return {@link R}
     */
    @GetMapping("/getActivityConfig")
    R getActivityConfig(@RequestParam String Key, @RequestParam String storeType, @RequestParam(required = false) Long infoId);

}
