package com.yaoyaozw.customer.constants;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author darker
 * @date 2023/3/14 11:56
 */
public class FollowReplyCommonConstant {

    public final static String TENCENT_MEDIA_TYPE_PIC = "image";
    public final static String TENCENT_MEDIA_TYPE_VOICE = "voice";
    public final static String TENCENT_MEDIA_TYPE_NEWS = "news";
    public final static String TENCENT_MEDIA_TYPE_TEXT = "text";


    public static Boolean needUpload(String type) {
        return TENCENT_MEDIA_TYPE_PIC.equals(type) || TENCENT_MEDIA_TYPE_VOICE.equals(type);
    }

    public static Boolean needReferral(String type) {
        return TENCENT_MEDIA_TYPE_NEWS.equals(type) || TENCENT_MEDIA_TYPE_TEXT.equals(type);
    }

    public static String getTypeDesc(String type) {

        if (TENCENT_MEDIA_TYPE_PIC.equals(type)) {
            return "图片";
        } else if (TENCENT_MEDIA_TYPE_VOICE.equals(type)) {
            return "语音";
        } else if (TENCENT_MEDIA_TYPE_NEWS.equals(type)) {
            return "图文";
        } else if (TENCENT_MEDIA_TYPE_TEXT.equals(type)) {
            return "文本";
        }
        return "";

    }


}
