package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.vo.kanban.UserAvgAmountVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.mapper.AccountOrderMapper;
import com.yaoyaozw.customer.entity.AccountOrder;
import com.yaoyaozw.customer.service.AccountOrderService;

@Service
public class AccountOrderServiceImpl extends ServiceImpl<AccountOrderMapper, AccountOrder> implements AccountOrderService {


    @Autowired
    private RegisterUserEntityService registerUserEntityService;

    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Override
    public void activeUserByOrder(IntegrationRequestDTO integrationRequestDTO) {
        //获取runtime订单最新一版数据
        List<AccountOrder> runtimeOrders= baseMapper.findNewestRuntimeAccountOrder(integrationRequestDTO.getRequestDate());

        Set<String> openIdSet = runtimeOrders.stream().map(AccountOrder::getOpenId).collect(Collectors.toSet());

        Map<String, List<AccountOrder>> userOrderMap = runtimeOrders.stream().collect(Collectors.groupingBy(AccountOrder::getOpenId));

        if (!openIdSet.isEmpty()){
            //获取注册用户信息
            List<RegisterUserEntity> userList = registerUserEntityService.list(new QueryWrapper<RegisterUserEntity>().in(RegisterUserEntity.COL_OPEN_ID, openIdSet));

            if(!userList.isEmpty()){
                Set<String> appIdSet = userList.stream().map(RegisterUserEntity::getAppId).collect(Collectors.toSet());

                List<CustomerDelayItemVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerSort(appIdSet,3);

                Map<String, Map<Integer, Long>> delayMessageMap = allDelayCustomerMessage.stream().collect(Collectors.groupingBy(CustomerDelayItemVO::getAppId, Collectors.toMap(CustomerDelayItemVO::getPostSort, CustomerDelayItemVO::getTimeInterval, (v1, v2) -> v2)));

                for (RegisterUserEntity registerUser : userList) {
                    //获取用户订单
                    List<AccountOrder> accountOrders = userOrderMap.get(registerUser.getOpenId());

                    Date lastFinishTime=registerUser.getLastActive();
                    int type=registerUser.getPayType()!=null?registerUser.getPayType():0;
                    Double sum=registerUser.getPayAmount()!=null?registerUser.getPayAmount():0;

                    for (AccountOrder accountOrder : accountOrders) {
                        //最近活跃时间
                        lastFinishTime = (lastFinishTime != null && lastFinishTime.compareTo(accountOrder.getFinishTime()) > 0) ? lastFinishTime : accountOrder.getFinishTime();
                        //最大类型
                        type = Math.max(accountOrder.getType() + 1, type);
                        sum += accountOrder.getProfit();
                    }
                    //计算用户信息
                    if (registerUser.getLastActive()==null){
                        //如果没有活跃时间，记录为首次活跃
                        registerUser.setFirstActive(lastFinishTime);
                        //排期重置
                        delayCustomerManage(registerUser,lastFinishTime,integrationRequestDTO.getRequestDate(),delayMessageMap);
                    }
                    //活跃时间重置
                    registerUser.setLastActive(lastFinishTime);
                    //如果类型大于当前类型
                    registerUser.setPayType(type);
                    //累计次数
                    registerUser.setPayNum(registerUser.getPayNum()+accountOrders.size());
                    //累计金额
                    registerUser.setPayAmount(sum);
                }
                registerUserEntityService.updateBatchById(userList);
            }
        }
    }



    @Override
    public void calculateAvgMonth(IntegrationRequestDTO integrationRequestDTO) {
        //获取近一月每个用户的平均充值
        List<UserAvgAmountVO> userAvgAmountVos= baseMapper.findMonthDailyAccountOrder();
        Map<String, Double> userAvgAmountMap = userAvgAmountVos.stream().collect(Collectors.toMap(UserAvgAmountVO::getOpenId, UserAvgAmountVO::getAvgAmount, (v1, v2) -> v1));
        //获取付费用户信息
        List<RegisterUserEntity> userList = registerUserEntityService.list(new QueryWrapper<RegisterUserEntity>().gt(RegisterUserEntity.COL_PAY_TYPE, 0));

        if (userList!=null&&!userList.isEmpty()){

            for (RegisterUserEntity registerUserEntity : userList) {

                registerUserEntity.setAvgMonth(userAvgAmountMap.get(registerUserEntity.getOpenId()));
            }
        }
        registerUserEntityService.updateBatchById(userList);
    }



    /**
     * 延时客服排期
     * @param registerUserPublish
     */
    public void delayCustomerManage(RegisterUserEntity registerUserPublish, Date activeTime,Date currentDate, Map<String, Map<Integer, Long>> delayMessageMap){

        Map<Integer, Long> integerLongMap = delayMessageMap.get(registerUserPublish.getAppId());

        if (integerLongMap!=null&&!integerLongMap.isEmpty()){
            //找初始排期间隔时间
            Long firstDelayMessage = integerLongMap.get(1);

            Long secondDelayMessage = integerLongMap.get(2);

            Long thirdDelayMessage = integerLongMap.get(3);
            //如果活跃时间和当前的间隔大于首次排期间隔，则说明排1就扫不到了；
            if (firstDelayMessage!=null&&currentDate.getTime()-activeTime.getTime()<firstDelayMessage){
                //时间戳精确到分
                Date publishTime = new Date((activeTime.getTime()/(60*1000))*60*1000 + firstDelayMessage);
                registerUserPublish.setCustomerSort(1);
                registerUserPublish.setCustomerPublish(publishTime);

            }else if (secondDelayMessage!=null&&currentDate.getTime()-activeTime.getTime()<secondDelayMessage){

                Date publishTime = new Date((activeTime.getTime()/(60*1000))*60*1000+ secondDelayMessage);
                registerUserPublish.setCustomerSort(2);
                registerUserPublish.setCustomerPublish(publishTime);

            }else if(thirdDelayMessage!=null){
                Date publishTime = new Date((activeTime.getTime()/(60*1000))*60*1000 + thirdDelayMessage);
                registerUserPublish.setCustomerSort(3);
                registerUserPublish.setCustomerPublish(publishTime);

            }else{
                registerUserPublish.setCustomerSort(-1);
            }

        }
    }
}

