package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.MaterialMenuMain;
import com.yaoyaozw.customer.mapper.MaterialMenuMainVoMapper;
import com.yaoyaozw.customer.service.MaterialMenuMainService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: Dwl
 * @Date: 2024/05/31/22:31
 * @ClassName: MaterialMenuMainServiceImpl
 * @Version: V3.2.0
 * @Description:
 */
@Service
public class MaterialMenuMainServiceImpl extends ServiceImpl<MaterialMenuMainVoMapper, MaterialMenuMain> implements MaterialMenuMainService {
    @Override
    public List<MaterialMenuMain> getMaterialMenuMainVoInfo(List<String> appIds) {
        LambdaQueryWrapper<MaterialMenuMain> queryWrapper = new LambdaQueryWrapper<MaterialMenuMain>().in(MaterialMenuMain::getAppId, appIds);
        return this.baseMapper.selectList(queryWrapper);
    }
}
