package com.yaoyaozw.customer.entity;

import java.io.Serializable;
import java.util.Date;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

/**
 * 人群中包
 *
 * @author darker
 * @date 2022/09/16
 */
@Data
@TableName("crowd_package_main")
@NoArgsConstructor
public class CrowdPackage implements Serializable {
    /**
     * 主键ID
     */
    @Id
    @TableId("id")
    private Long id;

    /**
     * 人群包名称
     */
    @TableField("package_name")
    private String packageName;

    /**
     * 活跃时间左边界
     */
    @TableField("active_time_min")
    private Long activeTimeMin;

    /**
     * 活跃时间右边界
     */
    @TableField("active_time_max")
    private Long activeTimeMax;

    /**
     * 关注时间左边界
     */
    @TableField("follow_time_min")
    private Integer followTimeMin;

    /**
     * 关注时间右边界
     */
    @TableField("follow_time_max")
    private Integer followTimeMax;

    /**
     * 关注时间-开始
     */
    @TableField("follow_date_start")
    private Date followDateStart;

    /**
     * 关注时间-结束
     */
    @TableField("follow_date_end")
    private Date followDateEnd;

    /**
     * 人群包用户人数
     */
    @TableField("crowd_num")
    private Integer crowdNum;

    /**
     * 人数最后统计时间
     */
    @TableField("last_count_time")
    private Date lastCountTime;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @TableField("create_user")
    private Long createUser;

    /**
     * 修改时间
     */
    @TableField("modified_time")
    private Date modifiedTime;

    /**
     * 修改人
     */
    @TableField("modified_user")
    private Long modifiedUser;

    private static final long serialVersionUID = 1L;

    public CrowdPackage(Long id, String packageName, Double activeTimeMin, Double activeTimeMax, Integer followTimeMin, Integer followTimeMax, Date followDateStart, Date followDateEnd) {
        this.id = id;
        this.packageName = packageName;
        this.followTimeMin = followTimeMin == null || followTimeMin == 0 ? null : followTimeMin;
        this.followTimeMax = followTimeMax == null || followTimeMax == 0 ? null : followTimeMax;
        this.followDateStart = followDateStart;
        this.followDateEnd = followDateEnd;


        if (ObjectUtil.isNotNull(activeTimeMin)) {
            Double v = activeTimeMin * CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
            this.activeTimeMin = v.longValue();
        }
        if (ObjectUtil.isNotNull(activeTimeMax)) {
            Double v = (activeTimeMax * CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE);
            this.activeTimeMax = v.longValue();
        }
    }

    public void handleInfo(Date now, Long userId, Boolean isCreate) {
        if (isCreate) {
            this.createTime = now;
            this.createUser = userId;
        }
        this.modifiedTime = now;
        this.modifiedUser = userId;
    }
}

