package com.yaoyaozw.customer.vo.follow;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.entity.CustomerFollowReplyMultiNews;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2023/3/13 20:07
 */
@Data
public class FollowReplyInfoVO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    private String appid;

    private String name;

    private String type;

    private String originMediaUrl;

    private String extendTitle;

    private String extendDesc;
    /**
     * 小程序标题
     */
    private String mpTitle;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转路径
     */
    private String mpPath;

    private Integer sort;

    private AuthInfoVO authInfo;

    private CommonReferralBody referralBody;

    private List<FollowReplyMultiNewsVO> multiNewsList;

    private List<CommonReferralBody> textBodyList;

    public CommonReferralBody getReferralBody() {
        return ObjectUtil.isNull(referralBody) ? new CommonReferralBody() : referralBody;
    }

    public List<CommonReferralBody> getTextBodyList() {
        return textBodyList == null ? new ArrayList<>(4) : textBodyList;
    }
}
