package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerMessageTextSaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.vo.customer.CustomerMessageTextDetailVO;


/**
 * @author darker
 * @date 2022/10/12 10:49
 */
public interface CustomerGraphicsTextService extends IService<CustomerGraphics> {

    /**
     * 存储客服消息
     *
     * @param saveDto 保存实体
     * @return {@link GenericsResult}<{@link String}>
     */
    GenericsResult<String> insertCustomerMessage(CustomerMessageTextSaveDTO saveDto);

    /**
     * 新增客户内容
     *
     * @param referralDto 推荐dto
     * @return {@link GenericsResult}<{@link CustomerMessageTextDetailVO}>
     */
    GenericsResult<CustomerMessageTextDetailVO> insertCustomerContent(CustomerReferralDTO referralDto);

    /**
     * 获取文本客服详情
     *
     * @param id 主键id
     * @return {@link GenericsResult}<{@link CustomerMessageTextDetailVO}>
     */
    GenericsResult<CustomerMessageTextDetailVO> getCustomerTextDetail(Long id);


    /**
     * 删除客户内容
     *
     * @param contentId 文本内容id
     * @return {@link GenericsResult}<{@link CustomerMessageTextDetailVO}>
     */
    GenericsResult<CustomerMessageTextDetailVO> removeCustomerContent(Long contentId);
}
