package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayGraphicsDetailVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;

import java.util.List;
import java.util.Set;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
public interface CustomerGraphicsDelayService extends IService<CustomerGraphicsDelay> {

    /**
     * 找到延时客服
     * @param appidList
     * @param maxSortRage
     * @return
     */
    List<CustomerDelayItemVO>  findAllDelayCustomerSort(Set<String> appidList,Integer maxSortRage);

    /**
     * 更新发送人数
     * @param voList
     */
    void updateSendNumById (Set<CustomerDelayItemVO>voList);

    /**
     * 插入客户延迟
     *
     * @param saveDto 保存dto
     * @return {@link BaseResult}
     */
    BaseResult insertCustomerDelay(CustomerDelaySaveDTO saveDto);

    /**
     * 得到客户延迟细节
     *
     * @param id id
     * @return {@link GenericsResult}<{@link CustomerDelayGraphicsDetailVO}>
     */
    GenericsResult<CustomerDelayGraphicsDetailVO> getCustomerDelayDetail(Long id);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link PageInfo}<{@link CustomerDelayListVO}>>
     */
    GenericsResult<PageInfo<CustomerDelayListVO>> pageList(CustomerDelayQueryDTO queryDto);

    /**
     * 得到客户账户存在
     *
     * @param keyword 关键词
     * @return {@link GenericsResult}<{@link List}<{@link AuthInfoVO}>>
     */
    GenericsResult<List<AuthInfoVO>> getExistCustomerAccount(String keyword);

    /**
     * 删除客户延迟
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult removeCustomerDelay(Long id);

    /**
     * 删除批处理
     *
     * @param idList id列表
     * @return {@link BaseResult}
     */
    BaseResult removeBatch(List<Long> idList);

    /**
     * 复制
     *
     * @param appId         应用程序id
     * @param targetAppList 目标应用程序列表
     * @return {@link BaseResult}
     */
    BaseResult copy(String appId, List<String> targetAppList);

    /**
     * 获得认证列表
     *
     * @param keyword 关键字
     * @param appId 公众号id
     * @return {@link GenericsResult}<{@link List}<{@link AuthInfoVO}>>
     */
    GenericsResult<List<AuthInfoVO>> getAuthList(String keyword, String appId);

    /**
     * 让时间间隔列表
     *
     * @return {@link GenericsResult}<{@link List}<{@link CommonOptionResponseVO}>>
     */
    GenericsResult<List<CommonOptionResponseVO>> getTimeIntervalList();

    /**
     * 客户重新排序
     *
     * @param appId 应用程序id
     */
    void reSortCustomer(String appId);
}

