package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.mapper.MaterialCommonMapper;
import com.yaoyaozw.customer.service.CustomerServiceCommonService;
import com.yaoyaozw.customer.vo.CommonOptionResponseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/28 19:01
 */
@Service
public class CustomerServiceCommonServiceImpl implements CustomerServiceCommonService {

    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;
    @Autowired
    private MaterialCommonMapper materialCommonMapper;

    @Override
    public List<Long> getSetupIdListFromStaticCondition(List<String> expressList) {
        if (CollectionUtil.isEmpty(expressList)) {
            return new ArrayList<>();
        }
        return kanbanCommonMapper.getSetupIdListFromStaticCondition(expressList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getStoreList() {
        List<CommonOptionResponseVO> storeList = materialCommonMapper.getStoreList();
        return new GenericsResult<>(storeList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getCoverPicList() {
        List<CommonOptionResponseVO> coverPicList = materialCommonMapper.getCoverPicList();

        return new GenericsResult<>(coverPicList);
    }
}
