package com.yaoyaozw.customer.vo.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/10/8 17:13
 */
@Data
public class CustomerDelayGraphicsDetailVO implements Serializable {

    @ApiModelProperty("客服消息id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公众号ID")
    private String appId;

    @ApiModelProperty("标题")
    private String name;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String type;

    @ApiModelProperty("是否支付 0-否 1-是")
    @JsonSerialize(using = ToStringSerializer.class)
    private Integer isPay;

    @ApiModelProperty("素材图片路径")
    private String coverUrl;

    @ApiModelProperty("推广标题")
    private String extendTitle;

    @ApiModelProperty("素材文本内容")
    private String content;

    @ApiModelProperty("素材文本内容")
    private Integer postSort;

    @ApiModelProperty("时间间隔")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long timeInterval;

    @ApiModelProperty("链接相关内容")
    private CustomerReferralDTO customerReferralDto;

    private AuthInfoVO authInfoVo;

}
