package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.mapper.AuthorizerInfoMapper;
import com.yaoyaozw.customer.service.AuthorizerInfoService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;


/**
 * 授权人信息服务impl
 *
 * @author Admin
 * @date 2022/10/14
 */
@Service
public class AuthorizerInfoServiceImpl extends ServiceImpl<AuthorizerInfoMapper, AuthorizerInfo> implements AuthorizerInfoService {

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public AuthInfoVO getAuthInfoByAppid(String appid) {
        AuthInfoVO authInfo = this.baseMapper.getAuthInfoByAppid(appid);
        Object storeTypeName = redisTemplate.opsForHash().get("STORE_NAME_MAP", authInfo.getStoreType());
        if (storeTypeName != null) {
            authInfo.setStoreTypeName(String.valueOf(storeTypeName));
        }
        return authInfo;
    }

}
