package com.yaoyaozw.customer.mapper;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * @author darker
 * @date 2022/12/13 15:51
 */
@Repository
public interface MaterialAopCommonMapper {

    /**
     * 从表获取帐户
     *
     * @param primaryId  主键id
     * @param tableName  表名
     * @param columnName 列名
     * @return {@link String}
     */
    String getAccountFromTable(@Param("primaryId") String primaryId, @Param("tableName") String tableName, @Param("columnName") String columnName);

    /**
     * 得到用户角色级别
     *
     * @param userId 用户id
     * @return {@link Integer}
     */
    Integer getUserRoleLevel(@Param("userId") String userId);

}
