package com.yaoyaozw.customer.aop;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.entity.SystemOperateLog;
import com.yaoyaozw.customer.service.SystemOperateLogService;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Date;

/**
 * @author darker
 * @date 2022/12/9 11:41
 */
@Aspect
@Component
public class OperateLogAop {

    private final static Integer LOG_PARAM_LENGTH_LIMIT = 200;

    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private SystemOperateLogService operateLogService;
/*
    @Pointcut("@annotation(com.yaoyaozw.customer.annotations.OperateLog)")
    public void operateLogCut() {
        //操作日志切点
    }


    @Around("operateLogCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable{
        // 获取这个注解对应的方法
        Class<?> targetClazz = point.getTarget().getClass();
        MethodSignature signature = (MethodSignature)point.getSignature();
        // 根据方法名和方法参数获取该方法的实体对象
        Method targetMethod = targetClazz.getDeclaredMethod(signature.getName(), signature.getParameterTypes());

        String param = objectMapper.writeValueAsString(point.getArgs());
        if (StringUtils.isNotBlank(param) && param.length() > LOG_PARAM_LENGTH_LIMIT) {
            param = param.substring(0, LOG_PARAM_LENGTH_LIMIT);
        }
        // 构造保存实体
        SystemOperateLog operateLogEntity = SystemOperateLog.builder()
                .methodPath(targetClazz.getName() + "." + targetMethod.getName())
                .operateTime(new Date())
                .requestParam(param)
                .operateUser(tokenManager.getUserIdFromToken())
                .build();

        // 获取这个方法上的对应注解的实体
        OperateLog operateLog = targetMethod.getAnnotation(OperateLog.class);
        if (ObjectUtil.isNotNull(operateLog)) {
            operateLogEntity.setOperateModule(operateLog.module());
            operateLogEntity.setOperateDesc(operateLog.desc());
        }

        long start = System.currentTimeMillis();
        try {
            return point.proceed();
        } catch (Throwable throwable) {
            operateLogEntity.setOperateResult(Boolean.FALSE);
            throw throwable;
        }finally {
            // 统计处理时间, 保存操作记录
            long end = System.currentTimeMillis();
            operateLogEntity.setTimeCost(end - start);
            operateLogService.save(operateLogEntity);
        }

    }*/

}
