package com.yaoyaozw.customer.enums;

import cn.hutool.core.util.ObjectUtil;

/**
 * @author darker
 * @date 2022/9/21 16:40
 */
public enum CrowdPackageConditionEnum {
    /**
     * 人群包条件的运算符枚举
     */

    GIANT_THAN("gt", ">", "大于"),
    LITTLE_THEN("lt", "<", "小于"),
    GIANT_AND_EQUALS("ge", ">=", "大于等于"),
    LITTLE_AND_EQUALS("le", "<=", "小于等于"),
    PURE_EQUALS("eq", "=", "等于"),
    ;


    /**
     * 关键
     */
    private final String key;

    /**
     * 意义
     */
    private final String meaning;

    /**
     * 描述
     */
    private final String description;

    CrowdPackageConditionEnum(String key, String meaning, String description) {
        this.key = key;
        this.meaning = meaning;
        this.description = description;
    }

    public String getKey() {
        return key;
    }

    public String getMeaning() {
        return meaning;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 获取运算信息
     * @param operator 运算符
     * @return 结果
     */
    public static CrowdPackageConditionEnum getInfoByOperator(String operator) {
        if (ObjectUtil.isNull(operator)) {
            return null;
        }
        for (CrowdPackageConditionEnum value : CrowdPackageConditionEnum.values()) {
            if (operator.equals(value.getKey())) {
                return value;
            }
        }
        return null;
    }

}
