package com.yaoyaozw.customer.vo.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/28 11:15
 */
@Data
public class CustomerDelayListVO implements Serializable {

    @ApiModelProperty("客服消息id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公众号")
    private String accountName;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String type;

    @ApiModelProperty("标题")
    private String name;

    @ApiModelProperty("消息发送时间")
    private String postTime;

    @ApiModelProperty("发文排序")
    private Integer postSort;

    @ApiModelProperty("时间间隔")
    private String timeInterval;

    @ApiModelProperty("发送状态值")
    private String sendStatus;

    @ApiModelProperty("发送状态描述")
    private String sendStatusStr;

    public String getType() {
        return CustomerCommonConstant.getCustomerType(this.type);
    }


}
