package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.entity.CustomerCommonLink;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.mapper.MaterialCommonMapper;
import com.yaoyaozw.customer.service.CustomerServiceCommonService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author darker
 * @date 2022/9/28 19:01
 */
@Service
public class CustomerServiceCommonServiceImpl implements CustomerServiceCommonService {

    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;
    @Autowired
    private MaterialCommonMapper materialCommonMapper;

    @Override
    public List<Long> getSetupIdListFromStaticCondition(List<String> expressList) {
        if (CollectionUtil.isEmpty(expressList)) {
            return new ArrayList<>();
        }
        return kanbanCommonMapper.getSetupIdListFromStaticCondition(expressList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getStoreList() {
        List<CommonOptionResponseVO> storeList = materialCommonMapper.getStoreList();
        return new GenericsResult<>(storeList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getCoverPicList() {
        List<CommonOptionResponseVO> coverPicList = materialCommonMapper.getCoverPicList();

        return new GenericsResult<>(coverPicList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getCommonLinkList() {
        List<CommonOptionResponseVO> commonLinkList = materialCommonMapper.getCommonLinkList();
        return new GenericsResult<>(commonLinkList);
    }

    @Override
    public List<AuthInfoVO> getAuthInfoList(Set<String> accountSet) {
        return materialCommonMapper.getAuthInfoList(accountSet);
    }

    @Override
    public Map<String, Map<String, String>> storeCommonLinkMap(String currentKey) {

        List<CustomerCommonLink> commonLinkMapping = materialCommonMapper.getCommonLinkMapping(currentKey);
        return commonLinkMapping.stream().collect(
                Collectors.groupingBy(CustomerCommonLink::getStoreType,
                        // 第二层map
                        HashMap::new, Collectors.groupingBy(CustomerCommonLink::getDictCurrentKey,
                                // 处理内层list
                                HashMap::new, Collectors.collectingAndThen(Collectors.toList(), item -> item.get(0).getOriginKey()))));

    }
}
