package com.yaoyaozw.customer.feigns;

import com.yaoyaozw.customer.annotations.AccountOperateControl;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.dto.MenuMainCopyDTO;
import com.yaoyaozw.customer.enums.AccountParamType;
import com.yaoyaozw.customer.enums.AccountTableColumnType;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * @Author: Dwl
 * @Date: 2024/03/27/18:10
 * @ClassName: MenuFeignClient
 * @Version: V3.2.0
 * @Description:
 */
@FeignClient(name = "material-service-dgn", path = "/menu")
public interface MenuFeignClient {
    @PostMapping("/copy")
    public BaseResult copy(@RequestBody @Validated MenuMainCopyDTO menuMainCopyDTO);
    @GetMapping("/removeMenu")
    @AccountOperateControl(paramType = AccountParamType.ACCOUNT_PRIMARY, paramName = "appId", columnType = AccountTableColumnType.APP_ID)
    public BaseResult removeMenu(@RequestParam Long id, @RequestParam String appId);
}
