package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.*;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/18:47
 * @ClassName: AccountDistributeRecord
 * @Version: V3.2.0
 * @Description:
 */
@Data
@TableName("account_distribute_record")
public class AccountDistributeRecord implements Serializable {
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 原公众号id
     */
    @TableField("auth_id")
    private Long authId;

    @TableField("target_auth_id")
    private Long targetAuthId;
    /**
     * 分发的菜单名称
     */
    @TableField("function_name")
    private String functionName;
    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    @TableField(value = "create_user", fill = FieldFill.INSERT)
    private Long createUser;
    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;
    /**
     * 成功次数
     */
    private Integer successCount;
    /**
     * 失败的原因
     */
    private String reason;

    private static final long serialVersionUID = 1L;


    public void saveDistribute(Long authId, Long targetId, List<String> functionName, Long createUser, Integer count, Map<String, String> reasonMap) {
        this.authId = authId;
        this.targetAuthId = targetId;
        this.functionName = groupName(functionName);
        this.createUser = createUser;
        this.successCount = count;
        this.reason = getReasonMapInfo(functionName, reasonMap);
        this.gmtCreate = new Date();
        this.gmtModified = new Date();
    }

    public String typeNameMap(String type) {
        Map<String, String> nameMap = new HashMap<>();
        nameMap.put("1", "关回");
        nameMap.put("2", "关键词");
        nameMap.put("3", "延时客服");
        nameMap.put("4", "菜单管理");

        return nameMap.get(type);
    }

    private String getReasonMapInfo(List<String> functionName, Map<String, String> reasonMap) {
        String name;
        List<String> nameList = new ArrayList<>(reasonMap.size());
        for (String type : functionName) {
            name = typeNameMap(type) + reasonMap.get(type);
            nameList.add(name);
        }
        if (nameList.isEmpty()) {
            return "";
        }
        return nameList.toString();
    }

    private String groupName(List<String> functionName) {
        StringBuilder name = new StringBuilder();
        for (String type : functionName) {
            switch (type) {
                case "1":
                    name.append("关回, ");
                    break;
                case "2":
                    name.append("关键词, ");
                    break;
                case "3":
                    name.append("延时客服, ");
                    break;
                case "4":
                    name.append("菜单管理, ");
                    break;
                default:
                    break;
            }
        }
        if (name.length() > 0) {
            name = new StringBuilder(name.substring(0, name.length() - 2));
        }
        return name.toString();
    }

}
