package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordCopyDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordQueryDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordSaveDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.entity.CustomerKeyword;
import com.yaoyaozw.customer.vo.keyword.CustomerKeywordInfoVO;
import com.yaoyaozw.customer.vo.keyword.CustomerKeywordListVO;

import java.util.List;

/**
 * @author darker
 * @date 2023/3/20 11:08
 */
public interface CustomerKeywordService extends IService<CustomerKeyword> {
    /**
     * 列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link List}<{@link CustomerKeywordListVO}>>
     */
    GenericsResult<List<CustomerKeywordListVO>> list(CustomerKeywordQueryDTO queryDto);

    /**
     * 创建
     *
     * @param saveDto 保存dto
     * @return {@link GenericsResult}<{@link String}>
     */
    GenericsResult<String> create(CustomerKeywordSaveDTO saveDto);

    /**
     * 创建文本项
     *
     * @param referralBody 推荐身体
     * @return {@link GenericsResult}<{@link List}<{@link CommonReferralBody}>>
     */
    GenericsResult<List<CommonReferralBody>> createTextItem(CommonReferralBody referralBody);

    /**
     * 得到信息
     *
     * @param id id
     * @return {@link GenericsResult}<{@link CustomerKeywordInfoVO}>
     */
    GenericsResult<CustomerKeywordInfoVO> getInfo(Long id);

    /**
     * 删除
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult remove(Long id);

    /**
     * 删除文本项
     *
     * @param id id
     * @return {@link GenericsResult}<{@link List}<{@link CommonReferralBody}>>
     */
    GenericsResult<List<CommonReferralBody>> removeTextItem(Long id);

    /**
     * 复制
     *
     * @param copyDto 复制dto
     * @return {@link BaseResult}
     */
    BaseResult copy(CustomerKeywordCopyDTO copyDto);
}
