package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 推荐实体
 *
 * @author Admin
 * @date 2022/10/08
 */
@ApiModel(value="referral_entity")
@Data
@TableName(value = "referral_entity")
public class ReferralEntity implements Serializable {
    @TableId(value = "id", type = IdType.ID_WORKER)
    @ApiModelProperty(value="")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 渠道id
     */
    @TableField(value = "account_id")
    @ApiModelProperty(value="渠道id")
    private String accountId;
    /**
     * name
     */
    @TableField(value = "name")
    @ApiModelProperty(value="name")
    private String name;

    /**
     * 小说名
     */
    @TableField(value = "book_id")
    @ApiModelProperty(value="小说名")
    private String bookId;

    /**
     * 章节
     */
    @TableField(value = "chapter_idx")
    @ApiModelProperty(value="章节")
    private Integer chapterIdx;

    /**
     * 素材表id
     */
    @TableField(value = "material_graphics_id")
    @ApiModelProperty(value="素材表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long materialGraphicsId;

    /**
     * 素材表id
     */
    @TableField(value = "material_graphics_info_id")
    @ApiModelProperty(value="素材表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long materialGraphicsInfoId;

    /**
     * 发文类型
     */
    @TableField(value = "news_type")
    @ApiModelProperty(value="发文类型")
    private Integer newsType;

    /**
     * 推广id
     */
    @TableField(value = "promote_id")
    @ApiModelProperty(value="推广id")
    private String promoteId;

    /**
     * 推广类型
     */
    @TableField(value = "push_type")
    @ApiModelProperty(value="推广类型")
    private Integer push;

    /**
     * 原文链接
     */
    @TableField(value = "referral")
    @ApiModelProperty(value="原文链接")
    private String referral;

    /**
     * 书成平台
     */
    @TableField(value = "store_type")
    @ApiModelProperty(value="书成平台")
    private String storeType;

    /**
     * 样式
     */
    @TableField(value = "style_type")
    @ApiModelProperty(value="样式")
    private Integer styleType;

    @TableField(value = "sort")
    @ApiModelProperty(value="序号")
    private Integer sort;

    @TableField(value = "text_content")
    @ApiModelProperty(value="文本内容")
    private String textContent;

    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    @ApiModelProperty(value="")
    private Date gmtCreate;

    @TableField(value = "gmt_create_user", fill = FieldFill.INSERT)
    @ApiModelProperty(value="")
    private String gmtCreateUser;

    @TableField(value = "gmt_modified", fill = FieldFill.INSERT)
    @ApiModelProperty(value="")
    private Date gmtModified;

    @TableField(value = "gmt_modified_user", fill = FieldFill.INSERT)
    @ApiModelProperty(value="")
    private String gmtModifiedUser;
    /**
     * 逻辑删除 1（true）已删除， 0（false）未删除
     */
    @TableLogic
    @TableField(value = "is_deleted", fill = FieldFill.INSERT)
    @ApiModelProperty(value="逻辑删除 1（true）已删除， 0（false）未删除")
    private Integer isDeleted;
    /**
     * name
     */
    @ApiModelProperty(value="bookName")
    @TableField(value = "book_name")
    private String bookName;
    /**
     * name
     */
    @ApiModelProperty(value="storeTypeName")
    @TableField(value = "store_type_name")
    private String storeTypeName;
    /**
     * name
     */
    @ApiModelProperty(value = "activityTitle")
    @TableField(value = "activity_title")
    private String activityTitle;
    /**
     * name
     */
    @ApiModelProperty(value = "configId")
    @TableField(value = "config_id")
    private String configId;
    /**
     * name
     */
    @ApiModelProperty(value = "templateId")
    @TableField(value = "template_id")
    private String templateId;
    /**
     * name
     */
    @ApiModelProperty(value = "startTime")
    @TableField(value = "start_time")
    private Date startTime;
    /**
     * name
     */
    @ApiModelProperty(value = "endTime")
    @TableField(value = "end_time")
    private Date endTime;
    /**
     * name
     */
    @ApiModelProperty(value = "rechargeAmount")
    @TableField(value = "recharge_amount")
    private BigDecimal rechargeAmount;
    /**
     * namev
     */
    @ApiModelProperty(value = "giftAmount")
    @TableField(value = "gift_amount")
    private Integer giftAmount;
    /**
     * namev
     */
    @ApiModelProperty(value = "limited")
    @TableField(value = "limited")
    private Integer limited;
    /**
     * name
     */
    @ApiModelProperty(value = "configId")
    @TableField(value = "config_name")
    private String configName;

    /**
     * 小程序标题
     */
    @TableField("mp_title")
    private String mpTitle;
    /**
     * 小程序appId
     */
    @TableField("mp_app_id")
    private String mpAppId;
    /**
     * 小程序跳转路径
     */
    @TableField("mp_path")
    private String mpPath;

    @TableField("media_id")
    private String mediaId;

    @TableField(exist = false)
    private String mediaOriginUrl;
    @TableField(exist = false)
    private String customerMsgType;

    @TableField(exist = false)
    @ApiModelProperty(value = "infoId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long infoId;

    @TableField(exist = false)
    private String h5Content;

    @TableField(exist = false)
    private String accountName;

    @TableField(exist = false)
    private String mediaSource;
    /**
     * 是否小程序相关请求
     */
    @TableField(exist = false)
    private Boolean miniProgramQuery;
    @TableField(exist = false)
    private String extraHttpUrl;

    public static final String COL_ID = "id";

    public static final String COL_ACCOUNT_ID = "account_id";

    public static final String COL_BOOK_ID = "book_id";

    public static final String COL_CHAPTER_IDX = "chapter_idx";

    public static final String COL_MATERIAL_GRAPHICS_ID = "material_graphics_id";

    public static final String COL_NEWS_TYPE = "news_type";

    public static final String COL_PROMOTE_ID = "promote_id";

    public static final String COL_REFERRAL = "referral";

    public static final String COL_STORE_TYPE = "store_type";

    public static final String COL_STYLE_TYPE = "style_type";

    public static final String COL_GMT_CREATE = "gmt_create";

    public static final String COL_GMT_CREATE_USER = "gmt_create_user";

    public static final String COL_GMT_MODIFIED = "gmt_modified";

    public static final String COL_GMT_MODIFIED_USER = "gmt_modified_user";

    public void changeDispatchBelong(Long id, Long materialGraphicsId, Long materialGraphicsInfoId) {
        this.id = id;
        this.materialGraphicsId = materialGraphicsId;
        this.materialGraphicsInfoId = materialGraphicsInfoId;
    }

}
