package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayTextSaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.vo.customer.CustomerDelayTextDetailVO;

/**
 * @author darker
 * @date 2022/10/17 16:38
 */
public interface CustomerDelayTextService extends IService<CustomerGraphicsDelay> {


    /**
     * 插入客户延迟
     *
     * @param saveDto 保存dto
     * @return {@link GenericsResult}<{@link String}>
     */
    GenericsResult<String> insertCustomerDelay(CustomerDelayTextSaveDTO saveDto);

    /**
     * 插入客户内容
     *
     * @param referralDto 推荐dto
     * @return {@link GenericsResult}<{@link CustomerDelayTextDetailVO}>
     */
    GenericsResult<CustomerDelayTextDetailVO> insertCustomerContent(CustomerReferralDTO referralDto);

    /**
     * 得到客户文本细节
     *
     * @param id id
     * @return {@link GenericsResult}<{@link CustomerDelayTextDetailVO}>
     */
    GenericsResult<CustomerDelayTextDetailVO> getCustomerTextDetail(Long id);

    /**
     * 删除客户内容
     *
     * @param contentId 内容识别
     * @return {@link GenericsResult}<{@link CustomerDelayTextDetailVO}>
     */
    GenericsResult<CustomerDelayTextDetailVO> removeCustomerContent(Long contentId);
}
