package com.yaoyaozw.customer.dto.crowd;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 14:19
 */
@Data
@ApiModel("人群包条件保存实体")
public class CrowdPackageConditionDTO implements Serializable {
    private static final long serialVersionUID = 347920438632761371L;


    @ApiModelProperty("关联Id")
    private Long matchId;

    @ApiModelProperty("条件Id")
    private Long conditionId;

    @ApiModelProperty("人群包主键")
    private Long packageId;

    @ApiModelProperty("比较运算符")
    private String compareOperator;

    @ApiModelProperty("设置的条件值")
    private String conditionValue;

    @ApiModelProperty("多选选项")
    private List<String> multipleOptions;

}
