package com.yaoyaozw.customer.listener;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.dto.AcquisitionExceptionHandleParam;
import com.yaoyaozw.customer.dto.WeChatTextDTO;
import com.yaoyaozw.customer.event.AcquisitionExceptionEvent;
import com.yaoyaozw.customer.feigns.MenuFeignClient;
import com.yaoyaozw.customer.utils.WeChatUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class MenuAcquisitionListener implements ApplicationListener<AcquisitionExceptionEvent> {

    @Resource
    private MenuFeignClient menuFeignClient;

    @Override
    public void onApplicationEvent(AcquisitionExceptionEvent acquisitionExceptionEvent) {
        AcquisitionExceptionHandleParam source = acquisitionExceptionEvent.getSource();
        if (source == null) {
            return;
        }
        try {
            BaseResult execResult = menuFeignClient.replaceAcquisitionLink(source);
            if (!execResult.getSuccess()) {
                log.error("公众号：{} 菜单链接从：{} 替换为：{} 失败：{}", source.getAuthorizerInfo().getNickName(), source.getFromPath(), source.getToPath(), execResult.getMessage());
                return;
            }
            // 发送报警信息
            String msg = "【菜单-获客链接替换】公众号：" + source.getAuthorizerInfo().getNickName() + " 获客链接：" + source.getFromPath() + " 已被替换为：" + source.getToPath();
            WeChatTextDTO cover = new WeChatTextDTO().cover(msg, null, null);
            WeChatUtils.sendErrorMessage(cover, "9934244e-9694-4a0c-95dd-ddd6ca4bd959");
        } catch (Exception e) {
            log.error("公众号：{} 菜单链接从：{} 替换为：{} 异常：{}", source.getAuthorizerInfo().getNickName(), source.getFromPath(), source.getToPath(), e.getMessage(), e);
        }
    }
}
