package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.service.AuthorizerTokenService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.wechat.service.WeChatService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.CustomerDelayPublish;
import com.yaoyaozw.customer.mapper.CustomerDelayPublishMapper;
import com.yaoyaozw.customer.service.CustomerDelayPublishService;

/**
 * 延时客服排期
 * @author wgh
 * @date 2022/9/28 18:51
*/
@Service
public class CustomerDelayPublishServiceImpl extends ServiceImpl<CustomerDelayPublishMapper, CustomerDelayPublish> implements CustomerDelayPublishService{


    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private AuthorizerTokenService authorizerTokenService;

    @Autowired
    private WeChatService weChatService;


    @Override
    public void sendCustomerDelayMessage(IntegrationRequestDTO integrationRequestDTO) {
        //读取延时客服排期
        List<CustomerDelayPublish> allPostUser = baseMapper.findPublishUser(integrationRequestDTO.getRequestDate());
        //涉及的appid
        Set<String> appidSet = allPostUser.stream().map(CustomerDelayPublish::getAppId).collect(Collectors.toSet());

        if (!allPostUser.isEmpty()){
            //号-用户
            Map<String, Map<String,CustomerDelayPublish>> userMap = allPostUser.stream().filter(a->a.getCustomerSort()!=null).collect(Collectors.groupingBy(CustomerDelayPublish::getAppId,Collectors.toMap(CustomerDelayPublish::getOpenId,a->a,(v1,v2)->v1)));
            //获取所有延时客服
            List<CustomerDelayItemVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerSort(appidSet,null);

            if (allDelayCustomerMessage!=null&&!allDelayCustomerMessage.isEmpty()){

                List<Future<CustomerDelayPublish>>futureList =new ArrayList<>();
                //号-发送序列-客服id
                Map<String, Map<Integer, List<CustomerDelayItemVO>>> customerMap =
                        allDelayCustomerMessage.stream().collect(Collectors.groupingBy(CustomerDelayItemVO::getAppId,
                        Collectors.groupingBy(CustomerDelayItemVO::getPostSort)));

                Set<CustomerDelayItemVO> needUpdateCustomerDelay = new HashSet<>();

                for (Map.Entry<String,  Map<String,CustomerDelayPublish>> userEntry : userMap.entrySet()) {

                    String appid = userEntry.getKey();
                    //获取该号token
                    AuthorizerToken authorizerToken = authorizerTokenService.findTokenByAppid(appid);

                    String token = authorizerToken.getAuthorizerAppid();
                    //没token过滤
                    if (token==null||"".equals(token)){ continue; }
                    //该号下延时客服
                    Map<Integer,List<CustomerDelayItemVO>> delaySortMap = customerMap.get(appid);
                    //所有的用户
                    Map<String,CustomerDelayPublish> userPublishMap = userEntry.getValue();
                    //去重
                    List<CustomerDelayPublish> userList = (List<CustomerDelayPublish>) userPublishMap.values();
                    
                    if (delaySortMap!=null&&!delaySortMap.isEmpty()){
                        //将所有待用延时客服收集
                        for (CustomerDelayPublish userPublish : userList) {
                            //发送延时客服
                            futureList.add(weChatService.sendCustomerDelayMessage(authorizerToken, userPublish, delaySortMap,needUpdateCustomerDelay)) ;
                        }
                    }
                }
                List<CustomerDelayPublish> registerUserEntities = new ArrayList<>();
                //更新下次延时排期
                for (Future<CustomerDelayPublish> delayPublishFuture : futureList) {
                    try {
                        registerUserEntities.add(delayPublishFuture.get()) ;

                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                if (!registerUserEntities.isEmpty()){

                    updateBatchById(registerUserEntities);
                }
                //更新延时客服的发送人数数据
                if (!needUpdateCustomerDelay.isEmpty()){

                    customerGraphicsDelayService.updateSendNumById(needUpdateCustomerDelay);
                }
            }

        }
    }
}
