package com.yaoyaozw.customer.dto.follow;

import cn.hutool.core.util.ObjectUtil;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author darker
 * @date 2023/3/13 19:59
 */
@Data
public class FollowReplySaveDTO implements Serializable {

    private Long id;

    @NotEmpty(message = "appid不能为空")
    private String appid;

    @NotEmpty(message = "素材名称不能为空")
    private String name;

    @NotEmpty(message = "素材类型不能为空")
    private String type;

    private String originMediaUrl;

    private String extendTitle;

    private String extendDesc;


    /**
     * 小程序标题
     */
    private String mpTitle;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转路径
     */
    private String mpPath;

    @NotNull(message = "素材排序不能为空")
    private Integer sort;

    private CommonReferralBody referralBody;

    private AuthInfoVO accountEntity;

    /**
     * 多图文的图文列表
     */
    private List<FollowReplyMultiNewsCreateDTO> multiNewsList;
}
