package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.dto.ConditionDTO;
import com.yaoyaozw.customer.dto.DistributeDTO;
import com.yaoyaozw.customer.entity.AccountDistributeRecord;
import com.yaoyaozw.customer.mapper.AccountDistributeLogMapper;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.vo.AccountDistributeLogVO;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.AccountSetupVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/17:22
 * @ClassName: DistributeServiceImpl
 * @Version: V3.2.0
 * @Description:
 */
@Slf4j
@Service
public class DistributeServiceImpl extends ServiceImpl<AccountDistributeLogMapper, AccountDistributeRecord> implements DistributeService {
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;
    @Autowired
    @Lazy
    private MyExecutorDistributeService myExecutorDistributeService;


    @Override
    public BaseResult distribute(DistributeDTO distributeDTO) {
        Long userId = tokenManager.getUserIdFromToken();
        List<AccountDistributeRecord> distributeLogList = new ArrayList<>();
        log.info("开始执行复用任务....");
        AuthInfoVO sourceAuth = distributeDTO.getSourceAuth();
        Integer targetAuthListSize = distributeDTO.getTargetAuthListSize();
        if (ObjectUtil.isNotNull(sourceAuth.getAppId())) {
            List<AccountSetupVO> accountSetupVOList = kanbanCommonMapper.getRole(userId, distributeDTO.getAccountId());
            int size = accountSetupVOList.size();
            if (targetAuthListSize != size) {
                return new BaseResult().error("暂无权限");
            }
        }
        myExecutorDistributeService.myExecutorDistribute(distributeDTO, userId, distributeLogList, sourceAuth);

        return new BaseResult().success("复用进行中, 请等待");
    }

    @Override
    public GenericsResult<PageInfo<AccountDistributeLogVO>> logList(ConditionDTO conditionDTO) {
        PageHelper.startPage(conditionDTO.getCurrentPage(), conditionDTO.getPageSize());
        List<AccountDistributeLogVO> accountDistributeLogVOList = this.baseMapper.selectLogList(conditionDTO);
        PageInfo<AccountDistributeLogVO> pageInfoList = new PageInfo<>(accountDistributeLogVOList);
        return new GenericsResult<>(pageInfoList);
    }
}
