package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.CustomerServiceCommonAsyncComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerMessageQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageSaveDTO;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.service.wechat.service.WeChatService;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.customer.CustomerMessageListVO;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.mapper.CustomerGraphicsMapper;

/**
 * 客户图形服务impl
 *
 * @author Admin
 * @date 2022/09/28
 */
@Service
public class CustomerGraphicsServiceImpl extends ServiceImpl<CustomerGraphicsMapper, CustomerGraphics> implements CustomerGraphicsService {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CustomerGraphicsServiceImpl.class);

    @Autowired
    private CrowdPackageConditionMatchService matchService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private CustomerServiceCommonAsyncComponent commonAsyncComponent;
    @Autowired
    private ReferralEntityService referralEntityService;
    @Autowired
    private WeChatService weChatService;
    @Autowired
    private RegisterUserEntityService registerUserEntityService;
    @Autowired
    private AuthorizerTokenService authorizerTokenService;


    @Override
    public BaseResult insertCustomerMessage(CustomerMessageSaveDTO saveDto) {

        // 主体数据
        LOCAL_LOG.info("处理主体数据");
        CustomerGraphics customerGraphics = new CustomerGraphics();
        BeanUtil.copyProperties(saveDto, customerGraphics);
        customerGraphics.initOperateInfo(tokenManager.getUserIdFromToken(), true);
        super.save(customerGraphics);

        // 处理活动数据
        ReferralEntity referralEntity = new ReferralEntity();
        BeanUtil.copyProperties(saveDto.getCustomerReferralDto(), referralEntity);
        referralEntity.setMaterialGraphicsId(customerGraphics.getId());

        referralEntityService.save(referralEntity);

        return new BaseResult().success();
    }

    @Override
    public BaseResult updateCustomerMessage(CustomerMessageSaveDTO saveDto) {
        return null;
    }

    @Override
    public GenericsResult<List<CustomerMessageListVO>> pageList(CustomerMessageQueryDTO queryDto) {
        return null;
    }

    @Override
    public BaseResult removeCustomerMessage(Long id) {
        return null;
    }

    @Override
    public void sendCustomerMessage(IntegrationRequestDTO integrationRequestDTO) {

        Date requestDate = integrationRequestDTO.getRequestDate();

        //当前时刻发送的客服（需要加启用禁用）
        List<CustomerGraphics> customerGraphicsList = list(new QueryWrapper<CustomerGraphics>().eq(CustomerGraphics.COL_POST_TIME, requestDate));

        for (CustomerGraphics customerGraphics : customerGraphicsList) {

            Long packId = customerGraphics.getPackId();

            /*
            根据人群包找人
             */
            List<CrowdPackageUserVO> userList=new ArrayList<>();


            Map<String, List<CrowdPackageUserVO>> appidUserMap = userList.stream().collect(Collectors.groupingBy(CrowdPackageUserVO::getAppId));

            //根据公众号找具体素材和链接
            List<ReferralEntityVo> referralList = referralEntityService.findReferralByCustomerGraphicsId(customerGraphics.getId());

            Map<String, List<ReferralEntityVo>> referralMap = referralList.stream().collect(Collectors.groupingBy(ReferralEntityVo::getAppid));
            //循环该客服下的所有素材
            for (Map.Entry<String, List<ReferralEntityVo>> referralEntry : referralMap.entrySet()) {

                String appid = referralEntry.getKey();
                //获取token
                AuthorizerToken authorizerToken = authorizerTokenService.findTokenByAppid(appid);

                if (authorizerToken!=null&&authorizerToken.getAuthorizerAccessToken()!=null){
                    //获取该号的链接实体
                    List<ReferralEntityVo> referralEntityVo = referralMap.get(appid);
                    //获取该号的openid
                    List<CrowdPackageUserVO> packageUserVo = appidUserMap.get(appid);

                    if (referralEntityVo!=null&&!referralEntityVo.isEmpty()){

                        weChatService.sendCustomerMessage(appid,authorizerToken.getAuthorizerAccessToken(),customerGraphics,packageUserVo,referralEntityVo);
                    }
                }
            }
        }
    }
}

