package com.yaoyaozw.customer.service;

import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;

import java.util.List;

public interface RegisterUserEntityService extends IService<RegisterUserEntity>{


    /**
     * 获取符合动态条件的用户
     *
     * @param dynamicExpressList 动态表达列表
     * @param openId 指定用户openId
     * @return {@link List}<{@link RegisterUserEntity}>
     */
    List<CrowdPackageUserVO> getUserMatchDynamicExpress(List<String> dynamicExpressList, String openId);

    /**
     * 从包中获取用户列表（现在已经在人群包内的）
     *
     * @param packageId 包id
     * @return {@link List}<{@link RegisterUserEntity}>
     */
    List<Long> getAccountIdListFromPackage(Long packageId);



}
