package com.yaoyaozw.customer.dto.customer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/15 11:14
 */
@Data
@ApiModel("延时客服保存实体")
public class CustomerMessageSaveDTO implements Serializable {
    private static final long serialVersionUID = -4269904448093268275L;

    @ApiModelProperty("客服消息id")
    private Long id;

    @ApiModelProperty("人群包ID")
    private Long packId;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("消息发送时间")
    private String postTime;

    @ApiModelProperty("是否支付 0-否 1-是")
    private Integer isPay;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private Integer type;

    @ApiModelProperty("素材文本内容")
    private String extendTitle;

    @ApiModelProperty("素材图片路径")
    private String coverUrl;

    @ApiModelProperty("素材文本内容")
    private String content;

    @ApiModelProperty("链接相关内容")
    private CustomerReferralDTO customerReferralDto;

}
