package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerMessageQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageSaveDTO;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import com.yaoyaozw.customer.vo.customer.CustomerMessageListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "客服消息接口")
@RestController
@RequestMapping("/customer-service/message")
public class CustomerMessageController {

    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @ApiOperation("新增")
    @PostMapping("/insert")
    public BaseResult insertCustomerMessage(@RequestBody CustomerMessageSaveDTO saveDto) {
        return customerGraphicsService.insertCustomerMessage(saveDto);
    }

    @ApiOperation("编辑")
    @PostMapping("/edit")
    public BaseResult updateCustomerMessage(@RequestBody CustomerMessageSaveDTO saveDto) {
        return customerGraphicsService.updateCustomerMessage(saveDto);
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<CustomerMessageListVO>> pageList(@RequestBody CustomerMessageQueryDTO queryDto) {
        return customerGraphicsService.pageList(queryDto);
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCustomerMessage(@PathVariable("id") Long id) {
        return customerGraphicsService.removeCustomerMessage(id);
    }


}
