package com.yaoyaozw.customer.vo.keyword;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.constants.CustomerMaterialConstant;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2023/3/13 20:07
 */
@Data
public class CustomerKeywordListVO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    private String keyword;

    private String authName;

    private String typeDesc;

    private String statusDesc;

    private String type;

    private Integer sort;

    public String getTypeDesc() {
        return CustomerMaterialConstant.getTypeDesc(this.type);
    }
}
